<?php defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require APPPATH.'/libraries/REST_Controller.php';

class Support extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth'));
		$this->load->model('applicationmodel');
		$this->load->model('applicationrequestmodel');
		$this->load->model('requestmodel');
		$this->load->model('usersmodel');
		$this->load->model('ticketsmodel');
		$this->load->helper('url'); 
		
		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via CAC, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}
		
		//check if user has agreed to dod banner
		$banner = $this->session->userdata('banner_agree');
		if (!isset($banner) || $banner !== 'true') {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	
	public function save(){
		$this->load->library('form_validation');
		$id = $this->usersmodel->get_user_id_from_org_id($this->encrypt->decode($this->session->userdata('user_id')));
		$message = $this->input->post('support_message', TRUE);
		$type = $this->input->post('type', TRUE);
		
		$this->form_validation->set_rules('support_message','Message','required|max_length[4000]');
		
		if($this->form_validation->run() === TRUE) {
			$this->ticketsmodel->create_ticket(NULL, $id, $message, date('U'), NULL, $type);
			
			$this->session->set_flashdata('success_message', 'Your message has been sent to the Administrators.');
		}else{
			$this->session->set_flashdata('error_message',validation_errors());
			$form_data = $this->input->post(NULL);
			foreach($form_data as $key => $value) {
				$this->session->set_flashdata($key, $value);
			}
		}
		
		redirect('onboarding');
	}
}